<?php

namespace Modules\Flowmaker\Services;

class ValidationResult
{
    public bool $isValid;
    public string $errorMessage;
    public array $testedConfig;
    public float $responseTime;
    public string $serverResponse;

    public function __construct(
        bool $isValid = false,
        string $errorMessage = '',
        array $testedConfig = [],
        float $responseTime = 0.0,
        string $serverResponse = ''
    ) {
        $this->isValid = $isValid;
        $this->errorMessage = $errorMessage;
        $this->testedConfig = $testedConfig;
        $this->responseTime = $responseTime;
        $this->serverResponse = $serverResponse;
    }

    public function toArray(): array
    {
        return [
            'isValid' => $this->isValid,
            'errorMessage' => $this->errorMessage,
            'testedConfig' => $this->testedConfig,
            'responseTime' => $this->responseTime,
            'serverResponse' => $this->serverResponse,
        ];
    }
}