<?php

namespace Modules\Flowmaker\Models\Nodes;
use Illuminate\Support\Facades\Log;
use Modules\Flowmaker\Models\Contact;

class Message extends Node
{
    
    public function process($message, $data)
    {
        Log::info('📝 Processing message in message node', [
            'node_id' => $this->id ?? 'unknown',
            'flow_id' => $this->flow_id ?? 'unknown',
            'message' => $message, 
            'data' => $data
        ]);
        // Get message from node data
        try{
            $message= $this->getDataAsArray()['settings']['message'];
            Log::info('Original message template', ['message' => $message]);

            //Find the contact
            $contactId = is_object($data) ? $data->contact_id : $data['contact_id'];
            $contact = Contact::find($contactId);
            Log::info('Contact found', ['contact_id' => $contactId, 'flow_id' => $this->flow_id]);

            //Transform the message
           $transformedMessage = $contact->changeVariables($message, $this->flow_id);
           Log::info('Transformed message', ['original' => $message, 'transformed' => $transformedMessage]);

            //Send the message
            $contact->sendMessage($transformedMessage,false);

        }catch(\Exception $e){
            Log::error('Error getting message from node data', ['error' => $e->getMessage()]);
        }
    

        // Continue flow to next node if one exists
        $nextNode = $this->getNextNodeId();
        if ($nextNode) {
            $nextNode->process($message, $data);
        }

        return [
            'success' => true
        ];
    }

    protected function getNextNodeId($data = null)
    {
        // Get the first outgoing edge's target
        Log::debug('🔍 Getting next node (Message)', [
            'current_node' => $this->id,
            'outgoing_edges_count' => count($this->outgoingEdges ?? []),
            'outgoing_edges' => $this->outgoingEdges ?? []
        ]);
        
        if (!empty($this->outgoingEdges)) {
            $nextNode = $this->outgoingEdges[0]->getTarget();
            Log::debug('✅ Next node found (Message)', [
                'current_node' => $this->id,
                'next_node' => $nextNode ? $nextNode->id : 'null'
            ]);
            return $nextNode;
        }
        
        // Fallback to parent method if no outgoing edges
        Log::debug('🔄 Falling back to parent getNextNodeId method (Message)');
        return parent::getNextNodeId($data);
    }
}
