@extends('layouts.app', ['title' => __('crm.connection_details')])

@section('content')
    <div class="header pb-8 pt-5 pt-md-8">
    </div>
    <div class="container-fluid mt--7">
        <div class="row">
            <div class="col">
                <div class="card shadow">
                    <div class="card-header border-0">
                        <div class="row align-items-center">
                            <div class="col-8">
                                <h3 class="mb-0">{{ $crmConnection->name }}</h3>
                                <p class="text-muted mb-0">{{ $crmConnection->type_display }}</p>
                            </div>
                            <div class="col-4 text-right">
                                <a href="{{ route('contacts.crm.edit', $crmConnection) }}" class="btn btn-sm btn-primary">
                                    <i class="ni ni-ruler-pencil"></i> {{ __('crm.edit') }}
                                </a>
                                <a href="{{ route('contacts.crm.index') }}" class="btn btn-sm btn-secondary">
                                    <i class="ni ni-bold-left"></i> {{ __('crm.back_to_connections') }}
                                </a>
                            </div>
                        </div>
                    </div>

                    <div class="card-body">
                        <div class="row">
                            <div class="col-md-6">
                                <h5>{{ __('crm.connection_info') }}</h5>
                                <table class="table table-sm">
                                    <tr>
                                        <td><strong>{{ __('crm.name') }}:</strong></td>
                                        <td>{{ $crmConnection->name }}</td>
                                    </tr>
                                    <tr>
                                        <td><strong>{{ __('crm.type') }}:</strong></td>
                                        <td>{{ $crmConnection->type_display }}</td>
                                    </tr>
                                    <tr>
                                        <td><strong>{{ __('crm.status') }}:</strong></td>
                                        <td>
                                            @if($crmConnection->is_active)
                                                <span class="badge badge-success">{{ __('crm.active') }}</span>
                                            @else
                                                <span class="badge badge-secondary">{{ __('crm.inactive') }}</span>
                                            @endif
                                        </td>
                                    </tr>
                                    <tr>
                                        <td><strong>{{ __('crm.health') }}:</strong></td>
                                        <td>
                                            @if($crmConnection->is_healthy)
                                                <span class="badge badge-success">{{ __('crm.healthy') }}</span>
                                            @else
                                                <span class="badge badge-danger">{{ __('crm.unhealthy') }}</span>
                                            @endif
                                        </td>
                                    </tr>
                                    <tr>
                                        <td><strong>{{ __('crm.last_sync') }}:</strong></td>
                                        <td>
                                            @if($crmConnection->last_sync_at)
                                                {{ $crmConnection->last_sync_at->format('M j, Y H:i') }}
                                                <br>
                                                <small class="text-muted">{{ $crmConnection->last_sync_at->diffForHumans() }}</small>
                                            @else
                                                <span class="text-muted">{{ __('crm.never') }}</span>
                                            @endif
                                        </td>
                                    </tr>
                                    <tr>
                                        <td><strong>{{ __('crm.last_test') }}:</strong></td>
                                        <td>
                                            @if($crmConnection->last_test_at)
                                                {{ $crmConnection->last_test_at->format('M j, Y H:i') }}
                                                <br>
                                                <small class="text-muted">{{ $crmConnection->last_test_at->diffForHumans() }}</small>
                                            @else
                                                <span class="text-muted">{{ __('crm.never') }}</span>
                                            @endif
                                        </td>
                                    </tr>
                                </table>
                            </div>
                            
                            <div class="col-md-6">
                                <h5>{{ __('crm.quick_actions') }}</h5>
                                <div class="d-grid gap-2">
                                    <a href="{{ route('contacts.crm-import.index') }}?connection={{ $crmConnection->id }}" 
                                       class="btn btn-primary">
                                        <i class="ni ni-cloud-download-95"></i> {{ __('crm.import_contacts') }}
                                    </a>
                                    <button type="button" 
                                            class="btn btn-outline-info"
                                            onclick="testConnection({{ $crmConnection->id }})">
                                        <i class="ni ni-settings"></i> {{ __('crm.test_connection') }}
                                    </button>
                                    <button type="button" 
                                            class="btn btn-outline-{{ $crmConnection->is_active ? 'warning' : 'success' }}"
                                            onclick="toggleConnectionStatus({{ $crmConnection->id }})">
                                        <i class="ni ni-{{ $crmConnection->is_active ? 'pause' : 'play' }}"></i>
                                        {{ $crmConnection->is_active ? __('crm.deactivate') : __('crm.activate') }}
                                    </button>
                                </div>
                            </div>
                        </div>

                        @if($crmConnection->error_message)
                            <div class="alert alert-danger mt-4">
                                <h6>{{ __('crm.error_message') }}</h6>
                                <p class="mb-0">{{ $crmConnection->error_message }}</p>
                            </div>
                        @endif

                        <!-- Recent Sync History -->
                        @if($crmConnection->syncHistory->isNotEmpty())
                            <div class="mt-5">
                                <h5>{{ __('crm.recent_sync_history') }}</h5>
                                <div class="table-responsive">
                                    <table class="table table-sm">
                                        <thead>
                                            <tr>
                                                <th>{{ __('crm.sync_type') }}</th>
                                                <th>{{ __('crm.status') }}</th>
                                                <th>{{ __('crm.records') }}</th>
                                                <th>{{ __('crm.started_at') }}</th>
                                                <th>{{ __('crm.duration') }}</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            @foreach($crmConnection->syncHistory as $history)
                                                <tr>
                                                    <td>{{ $history->sync_type_display }}</td>
                                                    <td>
                                                        @switch($history->status)
                                                            @case('completed')
                                                                <span class="badge badge-success">{{ $history->status_display }}</span>
                                                                @break
                                                            @case('in_progress')
                                                                <span class="badge badge-warning">{{ $history->status_display }}</span>
                                                                @break
                                                            @case('failed')
                                                                <span class="badge badge-danger">{{ $history->status_display }}</span>
                                                                @break
                                                            @default
                                                                <span class="badge badge-light">{{ $history->status_display }}</span>
                                                        @endswitch
                                                    </td>
                                                    <td>{{ $history->processed_records }} / {{ $history->total_records }}</td>
                                                    <td>{{ $history->started_at ? $history->started_at->format('M j, H:i') : '-' }}</td>
                                                    <td>{{ $history->duration_human ?? '-' }}</td>
                                                </tr>
                                            @endforeach
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        @endif
                    </div>
                </div>
            </div>
        </div>

        @include('layouts.footers.auth')
    </div>
@endsection

@push('js')
<script>
function testConnection(connectionId) {
    // Implement connection testing
    alert('Connection testing functionality will be implemented here.');
}

function toggleConnectionStatus(connectionId) {
    const url = '{{ route("contacts.crm.toggle-status", ["crmConnection" => "PLACEHOLDER"]) }}'.replace('PLACEHOLDER', connectionId);
    fetch(url, {
        method: 'POST',
        headers: {
            'X-CSRF-TOKEN': '{{ csrf_token() }}',
            'Content-Type': 'application/json',
        },
    })
    .then(response => response.json())
    .then(data => {
        if (data.success) {
            location.reload();
        } else {
            alert(data.message || '{{ __('crm.status_toggle_failed') }}');
        }
    })
    .catch(error => {
        console.error('Error:', error);
        alert('{{ __('crm.status_toggle_failed') }}');
    });
}
</script>
@endpush