<?php

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

Route::prefix('contacts')->group(function() {
    Route::get('/', 'ContactsController@index');
});

// Demo CSV download - no authentication required
Route::get('contacts/import/demo-csv', 'Modules\Contacts\Http\Controllers\Main@downloadDemoCsv')->name('contacts.import.demo-csv');


Route::group([
    'middleware' =>[ 'web','impersonate','XssSanitizer','auth'],
    'namespace' => 'Modules\Contacts\Http\Controllers'
], function () {
    Route::prefix('contacts')->group(function() {

        //Contacts
        Route::get('contacts', 'Main@index')->name('contacts.index');
        Route::get('contacts/{contact}/edit', 'Main@edit')->name('contacts.edit');
        Route::get('contacts/create', 'Main@create')->name('contacts.create');
        Route::post('contacts', 'Main@store')->name('contacts.store');
        Route::put('contacts/{contact}', 'Main@update')->name('contacts.update');
        Route::get('contacts/del/{contact}', 'Main@destroy')->name('contacts.delete');
        Route::get('contacts/bulkremove/{contacts}', 'Main@bulkremove')->name('contacts.bulkremove');
        Route::get('contacts/subscribe/{contacts}', 'Main@subscribe')->name('contacts.subscribe');
        Route::get('contacts/unsubscribe/{contacts}', 'Main@unsubscribe')->name('contacts.unsubscribe');
        Route::get('contacts/assigntogroup/{contacts}', 'Main@assigntogroup')->name('contacts.assigntogroup');
        Route::get('contacts/removefromgroup/{contacts}', 'Main@removefromgroup')->name('contacts.removefromgroup');
        Route::get('contacts/assigntoagent/{contacts}', 'Main@assigntoagent')->name('contacts.assigntoagent');

        //Group
        Route::get('groups', 'GroupsController@index')->name('contacts.groups.index');
        Route::get('groups/{group}/edit', 'GroupsController@edit')->name('contacts.groups.edit');
        Route::get('groups/create', 'GroupsController@create')->name('contacts.groups.create');
        Route::post('groups', 'GroupsController@store')->name('contacts.groups.store');
        Route::put('groups/{group}', 'GroupsController@update')->name('contacts.groups.update');
        Route::get('groups/del/{group}', 'GroupsController@destroy')->name('contacts.groups.delete');

        //Field
        Route::get('fields', 'FieldsController@index')->name('contacts.fields.index');
        Route::get('fields/{field}/edit', 'FieldsController@edit')->name('contacts.fields.edit');
        Route::get('fields/create', 'FieldsController@create')->name('contacts.fields.create');
        Route::post('fields', 'FieldsController@store')->name('contacts.fields.store');
        Route::put('fields/{field}', 'FieldsController@update')->name('contacts.fields.update');
        Route::get('fields/del/{field}', 'FieldsController@destroy')->name('contacts.fields.delete');


        //Import
        Route::get('import', 'Main@importindex')->name('contacts.import.index');
        Route::post('import', 'Main@import')->name('contacts.import.store');
        Route::get('import-history', 'Main@importHistory')->name('contacts.import-history');
        
        // Enhanced Import Features
        Route::get('import/template-info', 'Main@getCsvTemplateInfo')->name('contacts.import.template-info');

        //CRM Connections - Redirect to CRM Dashboard
        Route::get('crm', 'CrmConnectionController@dashboard')->name('contacts.crm.index');
        Route::get('crm/create', 'CrmConnectionController@create')->name('contacts.crm.create');
        Route::post('crm', 'CrmConnectionController@store')->name('contacts.crm.store');
        Route::get('crm/{crmConnection}', 'CrmConnectionController@show')->name('contacts.crm.show');
        Route::get('crm/{crmConnection}/edit', 'CrmConnectionController@edit')->name('contacts.crm.edit');
        Route::put('crm/{crmConnection}', 'CrmConnectionController@update')->name('contacts.crm.update');
        Route::delete('crm/{crmConnection}', 'CrmConnectionController@destroy')->name('contacts.crm.destroy');
        Route::post('crm/test', 'CrmConnectionController@test')->name('contacts.crm.test');
        Route::post('crm/fields', 'CrmConnectionController@getFields')->name('contacts.crm.fields');
        Route::post('crm/{crmConnection}/toggle-status', 'CrmConnectionController@toggleStatus')->name('contacts.crm.toggle-status');

        //CRM Import
        Route::get('crm-import', 'Main@crmImportIndex')->name('contacts.crm-import.index');
        Route::post('crm-import', 'Main@crmImport')->name('contacts.crm-import.store');
        Route::get('crm-import/progress', 'Main@crmImportProgress')->name('contacts.crm-import.progress');
        Route::post('crm-import/cancel', 'Main@crmImportCancel')->name('contacts.crm-import.cancel');
        Route::get('crm-import/history', 'Main@crmImportHistory')->name('contacts.crm-import.history');
        Route::get('crm-import/history/{syncHistory}', 'Main@crmImportHistoryDetails')->name('contacts.crm-import.history.details');

        //CRM Dashboard - Comprehensive CRM Management
        Route::get('crm-dashboard', 'CrmConnectionController@dashboard')->name('contacts.crm-dashboard.index');
        
        //CRM Credentials Guide
        Route::get('crm-credentials-guide', function() {
            return view('contacts::crm.credentials-guide');
        })->name('contacts.crm.credentials-guide');
    });
});