<?php

namespace Modules\Flowmaker\Models\Traits;

trait InterpolatesVariables
{
    /**
     * Replace {{variable}} in a string using data from the contact and its state/context.
     *
     * @param string $string
     * @param \Modules\Flowmaker\Models\Contact $contact
     * @param int|null $flowId
     * @return string
     */
    public function interpolate($string, $contact, $flowId = null)
    {
        return preg_replace_callback('/\{\{([^}]+)\}\}/', function ($matches) use ($contact, $flowId) {
            $variable = trim($matches[1]);
            // Try to get from contact state if flowId is provided
            if ($flowId) {
                $value = $contact->getContactStateValue($flowId, $variable);
                if ($value !== null) {
                    return $value;
                }
            }
            // Try to get from contact attributes
            if (isset($contact->$variable)) {
                return $contact->$variable;
            }
            // If not found, return the original placeholder
            return $matches[0];
        }, $string);
    }
} 