<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateContactCrmMappingTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('contact_crm_mapping', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('company_id');
            $table->unsignedBigInteger('contact_id');
            $table->unsignedBigInteger('crm_connection_id');
            $table->string('crm_contact_id'); // External CRM contact ID
            $table->string('sync_status')->default('synced'); // synced, pending, failed, conflict
            $table->json('crm_data')->nullable(); // Store CRM contact data
            $table->timestamp('last_synced_at')->nullable();
            $table->text('sync_error')->nullable();
            $table->timestamps();
            $table->softDeletes();

            // Foreign key constraints
            $table->foreign('company_id')->references('id')->on('companies')->onDelete('cascade');
            $table->foreign('contact_id')->references('id')->on('contacts')->onDelete('cascade');
            $table->foreign('crm_connection_id')->references('id')->on('crm_connections')->onDelete('cascade');
            
            // Indexes
            $table->index(['company_id', 'contact_id']);
            $table->index(['company_id', 'crm_connection_id']);
            $table->index(['crm_connection_id', 'crm_contact_id']);
            $table->index('sync_status');
            
            // Unique constraint to prevent duplicate mappings
            $table->unique(['contact_id', 'crm_connection_id'], 'unique_contact_crm_mapping');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('contact_crm_mapping');
    }
}