<?php

return [
    // General
    'connections_title' => 'CRM Connections',
    'create_connection' => 'Create Connection',
    'add_connection' => 'Add Connection',
    'back_to_connections' => 'Back to Connections',
    'back_to_import' => 'Back to Import',
    'cancel' => 'Cancel',
    'close' => 'Close',
    'save' => 'Save',
    'edit' => 'Edit',
    'delete' => 'Delete',
    'actions' => 'Actions',
    'status' => 'Status',
    'type' => 'Type',
    'name' => 'Name',
    'health' => 'Health',
    'last_sync' => 'Last Sync',
    'never' => 'Never',
    'active' => 'Active',
    'inactive' => 'Inactive',
    'healthy' => 'Healthy',
    'unhealthy' => 'Unhealthy',
    'credentials' => 'Credentials',
    'field_mapping' => 'Field Mapping',
    'import_settings' => 'Import Settings',
    'duplicate_strategy' => 'Duplicate Strategy',
    'batch_size' => 'Batch Size',
    'assign_to_group' => 'Assign to Group',
    'no_group' => 'No Group',
    'processed' => 'Processed',
    'imported' => 'Imported',
    'duplicates' => 'Duplicates',
    'failed' => 'Failed',
    'started_at' => 'Started At',
    'duration' => 'Duration',
    'connection' => 'Connection',
    'sync_type' => 'Sync Type',
    'progress' => 'Progress',
    'records' => 'Records',
    'import_history' => 'Import History',
    'import_history_title' => 'Import History',
    'crm_import_title' => 'CRM Import',
    'csv_import' => 'CSV Import',
    'crm_import' => 'CRM Import',
    'advanced_crm_import' => 'Advanced CRM Import',
    'import_from_crm' => 'Import from CRM',
    'start_import' => 'Start Import',
    'cancel_import' => 'Cancel Import',
    'import_progress' => 'Import Progress',
    'import_starting' => 'Import starting...',
    'import_completed' => 'Import completed successfully!',
    'import_failed' => 'Import failed. Please check the error details.',
    'import_cancelled' => 'Import was cancelled.',
    'error_details' => 'Error Details',
    'confirm_delete' => 'Are you sure you want to delete this connection?',
    'confirm_cancel_import' => 'Are you sure you want to cancel this import?',
    'import_contacts' => 'Import Contacts',
    'view_connection' => 'View Connection',
    'edit_connection' => 'Edit Connection',
    'delete_connection' => 'Delete Connection',
    'activate' => 'Activate',
    'deactivate' => 'Deactivate',
    'connection_details' => 'Connection Details',
    'connection_info' => 'Connection Information',
    'quick_actions' => 'Quick Actions',
    'recent_sync_history' => 'Recent Sync History',
    'last_test' => 'Last Test',
    'error_message' => 'Error Message',
    'update_connection' => 'Update Connection',
    'update_credentials_description' => 'Update your CRM credentials. Leave fields empty to keep current values.',
    'connection_created' => 'Connection Created',
    'connection_updated' => 'Connection Updated',
    'connection_deleted' => 'Connection Deleted',
    'connection_activated' => 'Connection Activated',
    'connection_deactivated' => 'Connection Deactivated',

    // Connection Management
    'connection_name' => 'Connection Name',
    'crm_type' => 'CRM Type',
    'select_crm_type' => 'Select CRM Type',
    'activate_connection' => 'Activate Connection',
    'test_connection' => 'Test Connection',
    'connection_test_successful' => 'Connection test successful!',
    'connection_test_failed' => 'Connection test failed. Please check your credentials.',
    'connection_test_error' => 'An error occurred while testing the connection.',
    'connection_created_successfully' => 'CRM connection created successfully!',
    'connection_updated_successfully' => 'CRM connection updated successfully!',
    'connection_deleted_successfully' => 'CRM connection deleted successfully!',
    'connection_creation_failed' => 'Failed to create CRM connection.',
    'connection_update_failed' => 'Failed to update CRM connection.',
    'connection_deletion_failed' => 'Failed to delete CRM connection.',
    'connection_activated_successfully' => 'Connection activated successfully!',
    'connection_deactivated_successfully' => 'Connection deactivated successfully!',
    'status_toggle_failed' => 'Failed to toggle connection status.',
    'no_connections' => 'No CRM connections found.',
    'create_first_connection' => 'Create your first CRM connection',
    'no_crm_connections' => 'No CRM connections available.',
    'create_crm_connection_first' => 'Please create a CRM connection first.',

    // Field Mapping
    'field_mapping_description' => 'Map CRM fields to your contact fields. Leave empty to skip a field.',
    'select_field' => 'Select Field',
    'fields_fetch_failed' => 'Failed to fetch CRM fields.',

    // Import Process
    'select_connection' => 'Select Connection',
    'choose_connection' => 'Choose a connection',
    'skip_duplicates' => 'Skip Duplicates',
    'update_existing' => 'Update Existing',
    'merge_data' => 'Merge Data',
    'batch_size_help' => 'Number of contacts to process in each batch (1-1000)',
    'auto_assign_country' => 'Auto-assign country based on phone number',
    'create_missing_groups' => 'Create missing groups automatically',
    'import_started_successfully' => 'Import started successfully!',
    'import_failed' => 'Import failed. Please try again.',
    'import_cancelled_successfully' => 'Import cancelled successfully!',
    'import_cannot_be_cancelled' => 'Import cannot be cancelled at this time.',
    'import_cancellation_failed' => 'Failed to cancel import.',
    'progress_fetch_failed' => 'Failed to fetch import progress.',
    'cancel_failed' => 'Failed to cancel import.',
    'no_import_history' => 'No import history found.',
    'connection_unhealthy' => 'Selected connection is not healthy. Please check the connection status.',
    'import_success' => 'Import completed successfully!',
    'import_in_progress' => 'Import is in progress...',
    'import_cancelled' => 'Import was cancelled.',
    'import_failed_error' => 'Import failed. Please check the error details.',
    'select_duplicate_strategy' => 'Select how to handle duplicate contacts',
    'duplicate_strategy_help' => 'Choose how to handle contacts that already exist in your system',
    'batch_size_help_text' => 'Number of contacts to process at once (1-1000). Smaller batches use less memory.',
    'auto_assign_country_help' => 'Automatically detect and assign country based on phone number',
    'create_missing_groups_help' => 'Create new groups if they don\'t exist in your system',
    'import_preview' => 'Import Preview',
    'estimated_contacts' => 'Estimated Contacts',
    'import_summary' => 'Import Summary',
    'ready_to_import' => 'Ready to Import',
    'import_completed_successfully' => 'Import completed successfully!',
    'contacts_imported' => 'contacts imported',
    'contacts_updated' => 'contacts updated',
    'contacts_skipped' => 'contacts skipped',
    'import_took' => 'Import took',
    'view_imported_contacts' => 'View Imported Contacts',
    'start_new_import' => 'Start New Import',
    'import_instructions_title' => 'How to Import Contacts from CRM',
    'import_step_1' => 'Select your CRM connection from the dropdown',
    'import_step_2' => 'Choose how to handle duplicate contacts',
    'import_step_3' => 'Configure import settings (optional)',
    'import_step_4' => 'Click "Start Import" and monitor progress',
    'skip_duplicates_desc' => 'Skip contacts that already exist',
    'update_existing_desc' => 'Update existing contacts with new data',
    'merge_data_desc' => 'Merge new data with existing contact data',

    // Validation Messages
    'validation' => [
        'name_required' => 'Connection name is required.',
        'name_string' => 'Connection name must be a string.',
        'name_max' => 'Connection name may not be greater than 255 characters.',
        'type_required' => 'CRM type is required.',
        'type_invalid' => 'Selected CRM type is invalid.',
        'is_active_boolean' => 'Active status must be true or false.',
        'field_mapping_array' => 'Field mapping must be an array.',
        'credentials_required' => 'Credentials are required.',
        'credentials_string' => 'Credentials must be strings.',
        'credentials_invalid_format' => 'Invalid credentials format.',
        'connection_required' => 'CRM connection is required.',
        'connection_exists' => 'Selected CRM connection does not exist.',
        'duplicate_strategy_required' => 'Duplicate strategy is required.',
        'duplicate_strategy_invalid' => 'Selected duplicate strategy is invalid.',
        'batch_size_integer' => 'Batch size must be an integer.',
        'batch_size_min' => 'Batch size must be at least 1.',
        'batch_size_max' => 'Batch size may not be greater than 1000.',
        'properties_array' => 'Properties must be an array.',
        'group_exists' => 'Selected group does not exist.',
        'import_settings_array' => 'Import settings must be an array.',
    ],

    // Attributes
    'attributes' => [
        'name' => 'Connection Name',
        'type' => 'CRM Type',
        'is_active' => 'Active Status',
        'field_mapping' => 'Field Mapping',
        'connection' => 'CRM Connection',
        'duplicate_strategy' => 'Duplicate Strategy',
        'batch_size' => 'Batch Size',
        'properties' => 'Properties',
        'assign_to_group' => 'Assign to Group',
        'import_settings' => 'Import Settings',
    ],

    // Status Messages
    'status_messages' => [
        'pending' => 'Pending',
        'in_progress' => 'In Progress',
        'completed' => 'Completed',
        'failed' => 'Failed',
        'cancelled' => 'Cancelled',
        'synced' => 'Synced',
        'conflict' => 'Conflict',
    ],

    // Sync Types
    'sync_types' => [
        'import' => 'Import',
        'export' => 'Export',
        'sync' => 'Sync',
    ],

    // Duplicate Strategies
    'duplicate_strategies' => [
        'skip' => [
            'label' => 'Skip Duplicates',
            'description' => 'Skip contacts that already exist',
        ],
        'update' => [
            'label' => 'Update Existing',
            'description' => 'Update existing contacts with new data',
        ],
        'merge' => [
            'label' => 'Merge Data',
            'description' => 'Merge new data with existing contact data',
        ],
    ],

    // Health Status
    'health_status' => [
        'healthy' => 'Healthy',
        'unhealthy' => 'Unhealthy',
        'stale' => 'Stale',
        'inactive' => 'Inactive',
    ],

    // Error Messages
    'error_messages' => [
        'connection_failed' => 'Failed to establish connection to CRM.',
        'authentication_failed' => 'Authentication failed. Please check your credentials.',
        'rate_limit_exceeded' => 'Rate limit exceeded. Please try again later.',
        'invalid_response' => 'Invalid response from CRM.',
        'network_error' => 'Network error occurred while connecting to CRM.',
        'unknown_error' => 'An unknown error occurred.',
    ],

    // Success Messages
    'success_messages' => [
        'connection_established' => 'Connection established successfully!',
        'contacts_imported' => 'Contacts imported successfully!',
        'settings_saved' => 'Settings saved successfully!',
        'connection_updated' => 'Connection updated successfully!',
        'connection_deleted' => 'Connection deleted successfully!',
    ],
];