@extends('layouts.app', ['title' => __("Smart Contact Import - WhatsApp Marketing Automation")])

@section('content')
<div class="header pb-8 pt-5 pt-md-8" style="background: linear-gradient(135deg, #25D366 0%, #128C7E 100%);">
    <div class="container-fluid">
        <div class="row">
            <div class="col">
                <div class="text-center text-white">
                    <h1 class="display-4 font-weight-bold mb-3">
                        <i class="fab fa-whatsapp mr-3"></i>
                        Smart Contact Import
                    </h1>
                    <p class="lead mb-0">Automate your WhatsApp marketing with intelligent contact management</p>
                </div>
            </div>
        </div>
    </div>
</div>

<div class="container-fluid mt--7">
    <!-- Hero Section -->
    <div class="row mb-5">
        <div class="col-12">
            <div class="card shadow-lg border-0" style="background: linear-gradient(135deg, #f8f9fa 0%, #e9ecef 100%);">
                <div class="card-body p-5">
                    <div class="row align-items-center">
                        <div class="col-md-8">
                            <h2 class="text-dark mb-3">
                                <i class="fas fa-rocket text-success mr-2"></i>
                                WhatsApp Marketing Automation
                            </h2>
                            <p class="text-muted mb-4">
                                Transform your contact management with our intelligent import system.
                                Automatically normalize phone numbers, integrate with CRMs, and create
                                smart campaigns that respect WhatsApp API limits.
                            </p>
                            <div class="row">
                                <div class="col-md-4">
                                    <div class="feature-item text-center">
                                        <i class="fas fa-mobile-alt text-success fa-2x mb-2"></i>
                                        <h6 class="text-dark">Smart Phone Normalization</h6>
                                        <small class="text-muted">Auto-format any phone number</small>
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="feature-item text-center">
                                        <i class="fas fa-cloud text-primary fa-2x mb-2"></i>
                                        <h6 class="text-dark">CRM Integration</h6>
                                        <small class="text-muted">Direct import from HubSpot, Salesforce</small>
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="feature-item text-center">
                                        <i class="fas fa-chart-line text-warning fa-2x mb-2"></i>
                                        <h6 class="text-dark">Smart Campaigns</h6>
                                        <small class="text-muted">Intelligent batching & limits</small>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-4 text-center">
                            <div class="whatsapp-icon-container">
                                <i class="fab fa-whatsapp text-success" style="font-size: 8rem; opacity: 0.1;"></i>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Import Methods -->
    <div class="row">
        <div class="col-12">
            <div class="card shadow-lg border-0">
                <div class="card-header bg-white border-0 pb-0">
                    <div class="row align-items-center">
                        <div class="col-md-8">
                            <h3 class="mb-0 text-dark">
                                <i class="fas fa-upload text-success mr-2"></i>
                                Import Your Contacts
                            </h3>
                            <p class="text-muted mb-0">Choose your preferred import method</p>
                        </div>
                        <div class="col-md-4 text-right">
                            <button type="button" class="btn btn-success btn-lg" id="downloadDemoBtn" onclick="window.location.href='{{ route('contacts.import.demo-csv') }}'">
                                <i class="fas fa-download mr-2"></i>
                                Download Sample
                            </button>
                        </div>
                    </div>
                </div>

                <div class="col-12">
                    @include('partials.flash')
                </div>

                <div class="card-body p-4">
                    <!-- Import Methods Tabs -->
                    <ul class="nav nav-pills nav-fill mb-4" id="importTabs" role="tablist">
                        <li class="nav-item">
                            <a class="nav-link active" id="csv-tab" data-toggle="tab" href="#csv-import" role="tab">
                                <i class="fas fa-file-csv mr-2"></i>
                                <span class="d-none d-md-inline">CSV Import</span>
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" id="crm-tab" data-toggle="tab" href="#crm-import" role="tab">
                                <i class="fas fa-cloud mr-2"></i>
                                <span class="d-none d-md-inline">CRM Integration</span>
                            </a>
                        </li>
                    </ul>

                    <div class="tab-content" id="importTabsContent">
                        <!-- CSV Import Tab -->
                        <div class="tab-pane fade show active" id="csv-import" role="tabpanel">
                            <!-- Phone Format Examples -->
                            <div class="alert alert-info border-0 mb-4" style="background: linear-gradient(135deg, #e3f2fd 0%, #bbdefb 100%);">
                                <div class="row">
                                    <div class="col-md-6">
                                        <h6 class="text-primary mb-3">
                                            <i class="fas fa-magic mr-2"></i>
                                            Smart Phone Normalization
                                        </h6>
                                        <p class="mb-2">We automatically format any phone number:</p>
                                        <div class="phone-examples">
                                            <div class="phone-example">
                                                <code>+971 55 869 4287</code>
                                                <i class="fas fa-arrow-right text-muted mx-2"></i>
                                                <code class="text-success">+971558694287</code>
                                            </div>
                                            <div class="phone-example">
                                                <code>971558694287</code>
                                                <i class="fas fa-arrow-right text-muted mx-2"></i>
                                                <code class="text-success">+971558694287</code>
                                            </div>
                                            <div class="phone-example">
                                                <code>+1 (555) 123-4567</code>
                                                <i class="fas fa-arrow-right text-muted mx-2"></i>
                                                <code class="text-success">+15551234567</code>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <h6 class="text-primary mb-3">
                                            <i class="fas fa-info-circle mr-2"></i>
                                            Required Fields
                                        </h6>
                                        <ul class="list-unstyled mb-0">
                                            <li><i class="fas fa-check text-success mr-2"></i><strong>name</strong> - Contact's full name</li>
                                            <li><i class="fas fa-check text-success mr-2"></i><strong>phone</strong> - Any phone format</li>
                                        </ul>
                                        <h6 class="text-primary mt-3 mb-2">Optional Fields</h6>
                                        <ul class="list-unstyled mb-0">
                                            <li><i class="fas fa-plus text-info mr-2"></i><strong>email</strong> - Contact's email</li>
                                            <li><i class="fas fa-plus text-info mr-2"></i><strong>avatar</strong> - Profile picture URL</li>
                                            <li><i class="fas fa-plus text-info mr-2"></i><strong>custom_field</strong> - Any additional data</li>
                                        </ul>
                                    </div>
                                </div>
                            </div>

                            <!-- Import Form -->
                            <div class="card border-0 shadow-sm">
                                <div class="card-header bg-light border-0">
                                    <h6 class="mb-0 text-dark">
                                        <i class="fas fa-upload mr-2"></i>
                                        Upload Your CSV File
                                    </h6>
                                </div>
                                <div class="card-body">
                                    <form action="{{ route('contacts.import.store') }}" method="POST" enctype="multipart/form-data" id="importForm">
                                        @csrf

                                        <div class="row">
                                            <div class="col-md-6">
                                                <div class="form-group">
                                                    <label for="csv" class="form-label">
                                                        <i class="fas fa-file-csv mr-2"></i>
                                                        CSV File
                                                    </label>
                                                    <div class="custom-file">
                                                        <input type="file" class="custom-file-input" id="csv" name="csv" accept=".csv" required>
                                                        <label class="custom-file-label" for="csv" id="csv-label">Choose CSV file...</label>
                                                    </div>
                                                    <small class="form-text text-muted">
                                                        <i class="fas fa-info-circle mr-1"></i>
                                                        Upload your CSV file with the correct format
                                                    </small>
                                                </div>
                                            </div>
                                            <div class="col-md-6">
                                                <div class="form-group">
                                                    <label for="group" class="form-label">
                                                        <i class="fas fa-users mr-2"></i>
                                                        Group Assignment
                                                    </label>
                                                    <select class="form-control" id="group" name="group">
                                                        <option value="">Select a group (optional)</option>
                                                        @foreach($groups as $id => $name)
                                                        <option value="{{ $id }}">{{ $name }}</option>
                                                        @endforeach
                                                    </select>
                                                    <small class="form-text text-muted">
                                                        <i class="fas fa-info-circle mr-1"></i>
                                                        Assign imported contacts to a group
                                                    </small>
                                                </div>
                                            </div>
                                        </div>

                                        <div class="form-group mt-4">
                                            <button type="submit" class="btn btn-success btn-lg mr-3" id="importBtn">
                                                <i class="fas fa-upload mr-2"></i>
                                                Import Contacts
                                            </button>
                                            <button type="button" class="btn btn-outline-primary btn-lg" id="previewCsvBtn">
                                                <i class="fas fa-eye mr-2"></i>
                                                Preview CSV
                                            </button>
                                        </div>
                                    </form>
                                </div>
                            </div>
                        </div>

                        <!-- CRM Import Tab -->
                        <div class="tab-pane fade" id="crm-import" role="tabpanel">
                            <div class="mt-4">
                                @if(isset($crmConnections) && $crmConnections->isNotEmpty())
                                    <div class="row">
                                        @foreach($crmConnections as $connection)
                                            <div class="col-md-6 col-lg-4 mb-4">
                                                <div class="card h-100">
                                                    <div class="card-body">
                                                        <div class="d-flex justify-content-between align-items-start mb-3">
                                                            <h5 class="card-title">{{ $connection->name }}</h5>
                                                            <span class="badge badge-{{ $connection->is_healthy ? 'success' : 'danger' }}">
                                                                {{ $connection->is_healthy ? __('crm.healthy') : __('crm.unhealthy') }}
                                                            </span>
                                                        </div>
                                                        <p class="card-text">
                                                            <strong>{{ __('crm.type') }}:</strong> {{ $connection->type_display }}<br>
                                                            <strong>{{ __('crm.last_sync') }}:</strong> 
                                                            @if($connection->last_sync_at)
                                                                {{ $connection->last_sync_at->diffForHumans() }}
                                                            @else
                                                                {{ __('crm.never') }}
                                                            @endif
                                                        </p>
                                                        <a href="{{ route('contacts.crm-import.index') }}?connection={{ $connection->id }}" 
                                                           class="btn btn-primary btn-sm">
                                                            <i class="fas fa-download"></i> {{ __('crm.import_from_crm') }}
                                                        </a>
                                                    </div>
                                                </div>
                                            </div>
                                        @endforeach
                                    </div>
                                    
                                    <div class="text-center mt-4">
                                        <a href="{{ route('contacts.crm-dashboard.index') }}" class="btn btn-outline-primary">
                                            <i class="fas fa-cog"></i> {{ __('crm.advanced_crm_import') }}
                                        </a>
                                    </div>
                                @else
                                    <div class="text-center py-5">
                                        <i class="fas fa-plug fa-3x text-muted mb-3"></i>
                                        <h4>{{ __('crm.no_crm_connections') }}</h4>
                                        <p class="text-muted">{{ __('crm.create_crm_connection_first') }}</p>
                                        <a href="{{ route('contacts.crm.create') }}" class="btn btn-primary">
                                            <i class="fas fa-plus"></i> {{ __('crm.create_connection') }}
                                        </a>
                                    </div>
                                @endif
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- CSV Preview Modal -->
<div class="modal fade" id="csvPreviewModal" tabindex="-1" role="dialog">
    <div class="modal-dialog modal-xl" role="document">
        <div class="modal-content border-0 shadow-lg">
            <div class="modal-header bg-success text-white border-0">
                <h5 class="modal-title">
                    <i class="fas fa-eye mr-2"></i>
                    CSV Preview
                </h5>
                <button type="button" class="close text-white" data-dismiss="modal">
                    <span>&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <div id="csvPreviewContent">
                    <div class="text-center text-muted py-5">
                        <i class="fas fa-file-csv fa-3x mb-3"></i>
                        <p>Upload a CSV file to preview its contents.</p>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

@include('layouts.footers.auth')
@endsection

@push('scripts')
<script>
    // CSV parsing function
    function parseCSVLine(line) {
        const result = [];
        let current = '';
        let inQuotes = false;
        
        for (let i = 0; i < line.length; i++) {
            const char = line[i];
            
            if (char === '"') {
                inQuotes = !inQuotes;
            } else if (char === ',' && !inQuotes) {
                result.push(current);
                current = '';
            } else {
                current += char;
            }
        }
        
        result.push(current);
        return result;
    }

    // Simple initialization
    $(document).ready(function() {
        console.log('Document ready - starting import functionality');
        console.log('jQuery loaded:', typeof $ !== 'undefined');
        
        // Test if jQuery is working
        console.log('Total buttons on page:', $('button').length);
        console.log('Preview button found:', $('#previewCsvBtn').length);

        // File input change handler
        $('#csv').on('change', function() {
            console.log('File input changed');
            const file = this.files[0];
            const label = $('#csv-label');

            console.log('File selected:', file ? file.name : 'none');
            console.log('Label element:', label.length);

            if (file) {
                label.text(file.name);
                console.log('Label updated to:', file.name);
            } else {
                label.text('Choose CSV file...');
            }
        });

        // Download demo CSV
        $('#downloadDemoBtn').on('click', function() {
            console.log('Download button clicked');
            console.log('Route URL:', '{{ route("contacts.import.demo-csv") }}');
            window.location.href = '{{ route("contacts.import.demo-csv") }}';
        });
        
        // Alternative click handler for debugging
        document.getElementById('downloadDemoBtn').addEventListener('click', function(e) {
            console.log('Alternative click handler triggered');
            e.preventDefault();
            window.location.href = '{{ route("contacts.import.demo-csv") }}';
        });

        // Preview CSV
        $('#previewCsvBtn').on('click', function() {
            console.log('Preview button clicked');
            alert('Preview button clicked!'); // Simple test
            console.log('File input element:', $('#csv')[0]);
            console.log('Files:', $('#csv')[0].files);
            const file = $('#csv')[0].files[0];

            if (!file) {
                alert('Please select a CSV file first.');
                return;
            }

            console.log('Reading file:', file.name);

            const reader = new FileReader();
            reader.onload = function(e) {
                const csv = e.target.result;
                console.log('CSV content loaded:', csv.substring(0, 200) + '...');
                
                // Parse CSV properly
                const lines = csv.split('\n').filter(line => line.trim());
                if (lines.length === 0) {
                    alert('CSV file appears to be empty.');
                    return;
                }
                
                const headers = parseCSVLine(lines[0]);
                const previewRows = lines.slice(1, 6).map(line => parseCSVLine(line));

                let html = '<table class="table table-striped"><thead><tr>';
                headers.forEach(header => {
                    html += `<th>${header.trim()}</th>`;
                });
                html += '</tr></thead><tbody>';

                previewRows.forEach(row => {
                    if (row && row.length > 0) {
                        html += '<tr>';
                        row.forEach(cell => {
                            html += `<td>${cell.trim()}</td>`;
                        });
                        html += '</tr>';
                    }
                });
                html += '</tbody></table>';

                $('#csvPreviewContent').html(html);
                
                // Try to show modal with different methods
                try {
                    $('#csvPreviewModal').modal('show');
                    console.log('Modal shown with jQuery');
                } catch (e) {
                    console.log('jQuery modal failed, trying Bootstrap directly');
                    try {
                        const modal = new bootstrap.Modal(document.getElementById('csvPreviewModal'));
                        modal.show();
                        console.log('Modal shown with Bootstrap');
                    } catch (e2) {
                        console.log('Bootstrap modal failed, showing alert');
                        alert('Preview generated but modal could not be shown. Check console for details.');
                    }
                }
                
                console.log('Modal shown with', previewRows.length, 'rows');
            };
            
            reader.onerror = function() {
                console.error('Error reading file');
                alert('Error reading CSV file. Please try again.');
            };
            reader.readAsText(file);
        });

        console.log('All event listeners attached');
        console.log('Preview button element:', $('#previewCsvBtn')[0]);
        console.log('File input element:', $('#csv')[0]);
    }); // End of $(document).ready

</script>
@endpush

@push('styles')
<style>
    /* WhatsApp Brand Colors */
    :root {
        --whatsapp-green: #25D366;
        --whatsapp-dark-green: #128C7E;
        --whatsapp-blue: #34B7F1;
        --whatsapp-dark-blue: #075E54;
    }

    /* Custom Animations */
    @keyframes fadeInUp {
        from {
            opacity: 0;
            transform: translateY(30px);
        }
        to {
            opacity: 1;
            transform: translateY(0);
        }
    }

    @keyframes pulse {
        0% {
            transform: scale(1);
        }
        50% {
            transform: scale(1.05);
        }
        100% {
            transform: scale(1);
        }
    }

    /* Card Styles */
    .card {
        animation: fadeInUp 0.6s ease-out;
        transition: all 0.3s ease;
    }

    .card:hover {
        transform: translateY(-5px);
        box-shadow: 0 20px 40px rgba(0, 0, 0, 0.1) !important;
    }

    /* Button Styles */
    .btn {
        border-radius: 50px;
        font-weight: 600;
        text-transform: uppercase;
        letter-spacing: 0.5px;
        transition: all 0.3s ease;
    }

    .btn:hover {
        transform: translateY(-2px);
        box-shadow: 0 10px 20px rgba(0, 0, 0, 0.2);
    }

    .btn-success {
        background: linear-gradient(135deg, var(--whatsapp-green) 0%, var(--whatsapp-dark-green) 100%);
        border: none;
    }

    .btn-success:hover {
        background: linear-gradient(135deg, var(--whatsapp-dark-green) 0%, var(--whatsapp-green) 100%);
    }

    /* Nav Pills */
    .nav-pills .nav-link {
        border-radius: 50px;
        margin: 0 5px;
        transition: all 0.3s ease;
    }

    .nav-pills .nav-link.active {
        background: linear-gradient(135deg, var(--whatsapp-green) 0%, var(--whatsapp-dark-green) 100%);
        color: white;
        transform: translateY(-2px);
        box-shadow: 0 5px 15px rgba(37, 211, 102, 0.4);
    }

    .nav-pills .nav-link:hover:not(.active) {
        background-color: rgba(37, 211, 102, 0.1);
        color: var(--whatsapp-green);
    }

    /* Phone Examples */
    .phone-examples {
        background: rgba(255, 255, 255, 0.1);
        border-radius: 10px;
        padding: 15px;
    }

    .phone-example {
        margin: 8px 0;
        font-family: 'Courier New', monospace;
    }

    .phone-example code {
        background: rgba(255, 255, 255, 0.2);
        color: white;
        padding: 5px 10px;
        border-radius: 5px;
        font-size: 0.9rem;
    }

    /* Feature Items */
    .feature-item {
        padding: 20px;
        border-radius: 15px;
        background: rgba(255, 255, 255, 0.1);
        transition: all 0.3s ease;
    }

    .feature-item:hover {
        background: rgba(255, 255, 255, 0.2);
        transform: translateY(-5px);
    }

    /* Form Controls */
    .form-control {
        border-radius: 10px;
        border: 2px solid #e9ecef;
        transition: all 0.3s ease;
    }

    .form-control:focus {
        border-color: var(--whatsapp-green);
        box-shadow: 0 0 0 0.2rem rgba(37, 211, 102, 0.25);
    }

    .custom-file-label {
        border-radius: 10px;
        border: 2px solid #e9ecef;
    }

    .custom-file-input:focus~.custom-file-label {
        border-color: var(--whatsapp-green);
        box-shadow: 0 0 0 0.2rem rgba(37, 211, 102, 0.25);
    }

    /* Table Styles */
    .table {
        border-radius: 10px;
        overflow: hidden;
    }

    .table thead th {
        background: linear-gradient(135deg, var(--whatsapp-dark-green) 0%, var(--whatsapp-green) 100%);
        color: white;
        border: none;
        font-weight: 600;
        text-transform: uppercase;
        letter-spacing: 0.5px;
    }

    .table tbody tr {
        transition: all 0.3s ease;
    }

    .table tbody tr:hover {
        background-color: rgba(37, 211, 102, 0.1);
        transform: scale(1.01);
    }

    /* Modal Styles */
    .modal-content {
        border-radius: 20px;
        overflow: hidden;
    }

    .modal-header {
        background: linear-gradient(135deg, var(--whatsapp-green) 0%, var(--whatsapp-dark-green) 100%);
    }

    /* WhatsApp Icon Animation */
    .whatsapp-icon-container {
        animation: pulse 2s infinite;
    }

    /* Responsive Design */
    @media (max-width: 768px) {
        .display-4 {
            font-size: 2rem;
        }
        .btn-lg {
            padding: 0.5rem 1rem;
            font-size: 0.9rem;
        }
        .feature-item {
            margin-bottom: 20px;
        }
        .phone-examples {
            margin-top: 20px;
        }
    }

    /* Loading States */
    .btn:disabled {
        opacity: 0.7;
        cursor: not-allowed;
    }

    /* Success Animations */
    @keyframes checkmark {
        0% {
            transform: scale(0);
        }
        50% {
            transform: scale(1.2);
        }
        100% {
            transform: scale(1);
        }
    }

    .fa-check {
        animation: checkmark 0.5s ease-in-out;
    }

    /* Gradient Text */
    .gradient-text {
        background: linear-gradient(135deg, var(--whatsapp-green) 0%, var(--whatsapp-blue) 100%);
        -webkit-background-clip: text;
        -webkit-text-fill-color: transparent;
        background-clip: text;
    }

    /* Custom Scrollbar */
    ::-webkit-scrollbar {
        width: 8px;
    }

    ::-webkit-scrollbar-track {
        background: #f1f1f1;
        border-radius: 10px;
    }

    ::-webkit-scrollbar-thumb {
        background: linear-gradient(135deg, var(--whatsapp-green) 0%, var(--whatsapp-dark-green) 100%);
        border-radius: 10px;
    }

    ::-webkit-scrollbar-thumb:hover {
        background: linear-gradient(135deg, var(--whatsapp-dark-green) 0%, var(--whatsapp-green) 100%);
    }
</style>
@endpush
