<?php

return [
    'name' => 'Contacts',
    
    // CRM Integration Configuration
    'crm' => [
        'enabled' => true,
        'supported_types' => [
            'hubspot' => true,
            'salesforce' => true,
            'pipedrive' => true,
            'odoo' => true,
            'zoho' => false,
            'monday' => false,
            'airtable' => false,
        ],
        'default_batch_size' => 100,
        'max_batch_size' => 1000,
        'import_timeout' => 300, // 5 minutes
        'retry_attempts' => 3,
        'retry_delay' => 5, // seconds
    ],
    
    // Field Mapping Configuration
    'field_mapping' => [
        'name' => [
            'hubspot' => 'firstname',
            'salesforce' => 'FirstName',
            'pipedrive' => 'first_name',
            'odoo' => 'name',
        ],
        'email' => [
            'hubspot' => 'email',
            'salesforce' => 'Email',
            'pipedrive' => 'email',
            'odoo' => 'email',
        ],
        'phone' => [
            'hubspot' => 'phone',
            'salesforce' => 'Phone',
            'pipedrive' => 'phone',
            'odoo' => 'phone',
        ],
        // Company-specific fields
        'vat_number' => [
            'odoo' => 'vat',
        ],
        'title' => [
            'odoo' => 'title',
        ],
        'function' => [
            'odoo' => 'function',
        ],
        'language' => [
            'odoo' => 'lang',
        ],
        'timezone' => [
            'odoo' => 'tz',
        ],
        'contact_type' => [
            'odoo' => 'is_company',
        ],
    ],
    
    // Duplicate Detection Configuration
    'duplicate_detection' => [
        'enabled' => true,
        'fields' => ['email', 'phone'],
        'strict_mode' => false,
    ],
];