<?php

namespace Modules\Contacts\Providers;

use Illuminate\Support\ServiceProvider;
use Modules\Contacts\Services\PhoneNormalizationService;
use Modules\Contacts\Services\DemoCsvService;

/**
 * Contact Service Provider
 * 
 * Registers contact-related services for dependency injection
 * following Laravel best practices.
 * 
 * @package Modules\Contacts\Providers
 * @author WA-Tawasul Team
 * @version 1.0.0
 */
class ContactServiceProvider extends ServiceProvider
{
    /**
     * Register services.
     *
     * @return void
     */
    public function register(): void
    {
        // Register Phone Normalization Service
        $this->app->singleton(PhoneNormalizationService::class, function ($app) {
            return new PhoneNormalizationService();
        });

        // Register Demo CSV Service
        $this->app->singleton(DemoCsvService::class, function ($app) {
            return new DemoCsvService();
        });

        // Register aliases for easier access
        $this->app->alias(PhoneNormalizationService::class, 'phone.normalization');
        $this->app->alias(DemoCsvService::class, 'demo.csv');
    }

    /**
     * Bootstrap services.
     *
     * @return void
     */
    public function boot(): void
    {
        // Publish configuration files if needed
        if ($this->app->runningInConsole()) {
            $this->publishes([
                __DIR__ . '/../Config/config.php' => config_path('contacts.php'),
            ], 'contacts-config');
        }
    }

    /**
     * Get the services provided by the provider.
     *
     * @return array
     */
    public function provides(): array
    {
        return [
            PhoneNormalizationService::class,
            DemoCsvService::class,
        ];
    }
}