@extends('layouts.app', ['title' => __('crm.import_history_title')])

@section('content')
    <div class="header pb-8 pt-5 pt-md-8">
    </div>
    <div class="container-fluid mt--7">
        <div class="row">
            <div class="col">
                <div class="card shadow">
                    <div class="card-header border-0">
                        <div class="row align-items-center">
                            <div class="col-8">
                                <h3 class="mb-0">{{ __('crm.import_history_title') }}</h3>
                            </div>
                            <div class="col-4 text-right">
                                <a href="{{ route('contacts.crm-dashboard.index') }}" class="btn btn-sm btn-primary">
                                    <i class="fas fa-arrow-left"></i> {{ __('crm.back_to_import') }}
                                </a>
                            </div>
                        </div>
                    </div>

                    <div class="col-12">
                        @include('partials.flash')
                    </div>

                    <div class="table-responsive">
                        <table class="table align-items-center table-flush">
                            <thead class="thead-light">
                                <tr>
                                    <th scope="col">{{ __('crm.connection') }}</th>
                                    <th scope="col">{{ __('crm.sync_type') }}</th>
                                    <th scope="col">{{ __('crm.status') }}</th>
                                    <th scope="col">{{ __('crm.progress') }}</th>
                                    <th scope="col">{{ __('crm.records') }}</th>
                                    <th scope="col">{{ __('crm.started_at') }}</th>
                                    <th scope="col">{{ __('crm.duration') }}</th>
                                    <th scope="col">{{ __('crm.actions') }}</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($syncHistory as $history)
                                    <tr>
                                        <td>
                                            <div class="media align-items-center">
                                                <div class="media-body">
                                                    <span class="name mb-0 text-sm">
                                                        {{ $history->crmConnection->name ?? 'Deleted Connection' }}
                                                    </span>
                                                    <br>
                                                    <small class="text-muted">
                                                        {{ $history->crmConnection->type_display ?? 'Unknown Type' }}
                                                    </small>
                                                </div>
                                            </div>
                                        </td>
                                        <td>
                                            <span class="badge badge-info">{{ $history->sync_type_display }}</span>
                                        </td>
                                        <td>
                                            @switch($history->status)
                                                @case('completed')
                                                    <span class="badge badge-success">
                                                        <i class="fas fa-check-circle"></i> {{ $history->status_display }}
                                                    </span>
                                                    @break
                                                @case('in_progress')
                                                    <span class="badge badge-warning">
                                                        <i class="fas fa-spinner fa-spin"></i> {{ $history->status_display }}
                                                    </span>
                                                    @break
                                                @case('failed')
                                                    <span class="badge badge-danger">
                                                        <i class="fas fa-times-circle"></i> {{ $history->status_display }}
                                                    </span>
                                                    @break
                                                @case('cancelled')
                                                    <span class="badge badge-secondary">
                                                        <i class="fas fa-ban"></i> {{ $history->status_display }}
                                                    </span>
                                                    @break
                                                @default
                                                    <span class="badge badge-light">{{ $history->status_display }}</span>
                                            @endswitch
                                        </td>
                                        <td>
                                            @if($history->status === 'in_progress')
                                                <div class="progress" style="width: 100px;">
                                                    <div class="progress-bar" 
                                                         role="progressbar" 
                                                         style="width: {{ $history->progress_percentage }}%">
                                                    </div>
                                                </div>
                                                <small class="text-muted">{{ $history->progress_percentage }}%</small>
                                            @else
                                                <span class="text-muted">-</span>
                                            @endif
                                        </td>
                                        <td>
                                            <div class="text-center">
                                                <strong>{{ $history->processed_records }}</strong> / {{ $history->total_records }}
                                                <br>
                                                <small class="text-success">✓ {{ $history->successful_records }}</small>
                                                @if($history->duplicate_records > 0)
                                                    <small class="text-warning">⚠ {{ $history->duplicate_records }}</small>
                                                @endif
                                                @if($history->failed_records > 0)
                                                    <small class="text-danger">✗ {{ $history->failed_records }}</small>
                                                @endif
                                            </div>
                                        </td>
                                        <td>
                                            @if($history->started_at)
                                                {{ $history->started_at->format('M j, Y H:i') }}
                                                <br>
                                                <small class="text-muted">{{ $history->started_at->diffForHumans() }}</small>
                                            @else
                                                <span class="text-muted">-</span>
                                            @endif
                                        </td>
                                        <td>
                                            @if($history->duration_human)
                                                {{ $history->duration_human }}
                                            @else
                                                <span class="text-muted">-</span>
                                            @endif
                                        </td>
                                        <td>
                                            <div class="btn-group" role="group">
                                                @if($history->status === 'in_progress')
                                                    <button type="button" 
                                                            class="btn btn-sm btn-outline-danger"
                                                            onclick="cancelImport({{ $history->id }})">
                                                        <i class="fas fa-stop"></i>
                                                    </button>
                                                @endif
                                                
                                                @if($history->error_message)
                                                    <button type="button" 
                                                            class="btn btn-sm btn-outline-info"
                                                            onclick="showError('{{ addslashes($history->error_message) }}')">
                                                        <i class="fas fa-info-circle"></i>
                                                    </button>
                                                @endif
                                                
                                                <button type="button" 
                                                        class="btn btn-sm btn-outline-primary"
                                                        onclick="showDetails({{ $history->id }})">
                                                    <i class="fas fa-eye"></i>
                                                </button>
                                            </div>
                                        </td>
                                    </tr>
                                @empty
                                    <tr>
                                        <td colspan="8" class="text-center py-4">
                                            <div class="text-muted">
                                                <i class="fas fa-history fa-3x mb-3"></i>
                                                <p>{{ __('crm.no_import_history') }}</p>
                                                <a href="{{ route('contacts.crm-dashboard.index') }}" class="btn btn-primary">
                                                    {{ __('crm.start_import') }}
                                                </a>
                                            </div>
                                        </td>
                                    </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>

                    @if($syncHistory->hasPages())
                        <div class="card-footer py-4">
                            {{ $syncHistory->links() }}
                        </div>
                    @endif
                </div>
            </div>
        </div>

        @include('layouts.footers.auth')
    </div>
@endsection

@push('js')
<script>
function cancelImport(historyId) {
    if (confirm('{{ __('crm.confirm_cancel_import') }}')) {
        fetch(`{{ route('contacts.crm-import.cancel') }}`, {
            method: 'POST',
            headers: {
                'X-CSRF-TOKEN': '{{ csrf_token() }}',
                'Content-Type': 'application/json',
            },
            body: JSON.stringify({
                sync_history_id: historyId
            })
        })
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                location.reload();
            } else {
                alert(data.message || '{{ __('crm.cancel_failed') }}');
            }
        })
        .catch(error => {
            console.error('Error:', error);
            alert('{{ __('crm.cancel_failed') }}');
        });
    }
}

function showError(errorMessage) {
    alert('{{ __('crm.error_details') }}:\n\n' + errorMessage);
}

function showDetails(historyId) {
    // Open sync history details page
    window.open(`{{ route('contacts.crm-import.history.details', '') }}/${historyId}`, '_blank');
}
</script>
@endpush