<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('flows', function (Blueprint $table) {
            $table->integer('priority')->default(0)->after('flow_data');
            $table->boolean('is_active')->default(true)->after('priority');
            $table->index(['priority', 'is_active'], 'idx_flows_priority_active');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('flows', function (Blueprint $table) {
            $table->dropIndex('idx_flows_priority_active');
            $table->dropColumn(['priority', 'is_active']);
        });
    }
};
