/// <reference types="react" />
export declare const NodeIdContext: import("react").Context<string | null>;
export declare const Provider: import("react").Provider<string | null>;
export declare const Consumer: import("react").Consumer<string | null>;
/**
 * You can use this hook to get the id of the node it is used inside. It is useful
 * if you need the node's id deeper in the render tree but don't want to manually
 * drill down the id as a prop.
 *
 * @public
 * @returns The id for a node in the flow.
 *
 * @example
 *```jsx
 *import { useNodeId } from '@xyflow/react';
 *
 *export default function CustomNode() {
 *  return (
 *    <div>
 *      <span>This node has an id of </span>
 *      <NodeIdDisplay />
 *    </div>
 *  );
 *}
 *
 *function NodeIdDisplay() {
 *  const nodeId = useNodeId();
 *
 *  return <span>{nodeId}</span>;
 *}
 *```
 */
export declare const useNodeId: () => string | null;
export default NodeIdContext;
//# sourceMappingURL=NodeIdContext.d.ts.map